function [class] = punc_colo(punc_data,ori,chan,varargin)
%Synatax:   [class] = punc_colo(punc_data,1,[2 4 7],'thresh','uber','termi',3,'mod',1,'mod_fltr',1); 
%Input:     punc_data = the original puncta data structure from
%                   punc_locodist.
%           ori = the channel you want to use as the central pivot
%           chan = channel or channels that you want colocalized with your
%                   ori channel.
%           thresh = the threshold for colo.  [x x1 x2...] = each number
%                   represents the threshold for each corresponding
%                   channel, thus the termi size and thresh size must
%                   equal. Or 'median1' = median+1STD.  'median2' =
%                   median+2STD.  Auto1 = default.  'uber' = Elastic or
%                   sliding Distance mode. if termi not specified, it takes
%                   the first channel of chan. BTW, it makes the threshold
%                   med+2SD.  'Mode1' & 'Mode2' are added now.
%           termi = termi once specificed, kicks the function into uber
%                   classify mode, or elastic distance threshold mode,
%                   essentially create a ori-termi distance filter base
%                   vector
%           mod = 0 or 1.  0 = off (default) 1 = on.  When on the distance
%                   of the punctas are modified by the properties of
%                   punctas.
%           mod_fltr = 0 or 1. 0 = off(default) 1 = on.  When any parameter
%                   of a puncta that puts it 3std away will remove the
%                   puncta from consideration.
%Output:    class = The structure contains fields: number, vertex, name  
%                   Number: is the number of occurance of this class in the
%                           dataset.
%                   Vertex: the ori vertex that 
%                   Channels: the channels included in this category, e.g.,
%                   [1 3 5]
%                   names: the names of those channels
%                   threshold: the thresholds used for each channel.
%                   total_number: all the points that colo with all channels
%                   total_vertices: all the vertices that colo with all
%                       channels
%                   total_distances: all the distances of the channels away
%                       from the vertices that colo with all channels
%                   when uber is activated it just spits out an extra
%                   dataset similar to total, with slide infront.

%extract out some important data.
vertices = punc_data(ori).vertices;     %the vertices in question
distances = punc_data(ori).distance;    %the distances to all of the other channels

%rework the distance a little for easy use.
distances = distances(:,1,chan);       %we only need the distances for the channels we are interested
distances = reshape(distances,size(distances,1),size(chan,2));     %flatten in a xy array.

%initiate the toal remove index for finding total colocalization
total_idx = [];

%now parse threshold & error check
[mod,mod_fltr,thresh,termi] = parse(varargin,chan);

%create the modification index of the origin
if mod
    %pull some needed data
    vert_prop_ori = punc_data(ori).vert_all_prop;
    %figure out the modifier
    %get the medians for all props first
    %[y,x] = find(isnan(vert_prop_ori));   %remove not a number first
    vert_prop_tmp = vert_prop_ori;       %temp the variable to be worked on
    %vert_prop_tmp(y,:) = [];     %gone
    meds_ori = median(vert_prop_tmp);    %median
    %generate ori modification index
    ori_mod_idx = mean(vert_prop_ori./repmat(meds_ori,size(vert_prop_ori,1),1),2);
    %filter ori for outliers
    if mod_fltr
        %create the outlier filter array
        outlier_fltr = repmat((std(vert_prop_tmp)*3+meds_ori),size(vert_prop_ori,1),1);    %3 std away is too far
        %now filter out the outliers
        outlier_fltr = outlier_fltr<=vert_prop_ori;
        for i = 1:size(outlier_fltr,2)
            ori_mod_idx(outlier_fltr(:,i)) = NaN;   %outliers set to NaN
        end
    end
    %clear
    vert_prop_tmp = [];outlier_fltr = [];
end
%figure out the colo puncta
for i = 1:size(chan,2)         %step through channels
    distance = distances(:,i);  %pull out the relavent distances
    vertex = vertices;          %new variable so we do not destroy vertices.
    termi_vert = punc_data(ori).termi(:,:,chan(i));     %the terminal vertices
    %now lets filter the distances and the vertices for empty vertices
    [y,x] = find(isnan(distance));     %empty = no colo
    distance(y,:) = [];                %gone for threshold calculation
    %vertex(y,:) = [];                %gone (Wait for it...)
    %y_tmp = y;      %lets hold the value for later
    %calculate thresh if needed
    if ~isnumeric(thresh)
        switch thresh
            case 'auto0'
                thresh_now(i) = median(distance);
            case 'median1'
                thresh_now(i) = median(distance)+std(distance);      %thresh is median plus 1 standard deviation
            case 'median2'
                thresh_now(i) = median(distance)+std(distance)*2;    %thresh is median plus 2 standard deviation
            case 'mode1'
                thresh_now(i) = mode(distance)+std(distance);    %thresh is mode plus 2 standard deviation
            case 'mode2'
                thresh_now(i) = mode(distance)+std(distance)*2;    %thresh is mode plus 2 standard deviation
            case 'uber'
                thresh_now(i) = median(distance)+std(distance)*2;      %thresh is median plus 2 standard deviation
        end
    else
        thresh_now = thresh;    %numbers were given.
    end
    %now filter out none colo vertices
    distance = distances(:,i);  %reset
    %modify the distance based on the puncta parameters
    if mod
       %pull some needed data
       vert_prop = punc_data(ori).termi_prop(:,:,chan(i));
       %figure out the modifier
       %get the medians for all props first
       [y,x] = find(isnan(vert_prop));   %remove not a number first
       vert_prop_tmp = vert_prop;       %temp the variable to be worked on
       vert_prop_tmp(y,:) = [];     %gone
       meds_curr = median(vert_prop_tmp);    %median
       %modify the distances
       distance = (distance.*ori_mod_idx)./mean(vert_prop./repmat(meds_curr,size(vert_prop,1),1),2);
       %filter vertices for outliers
       if mod_fltr
           %create the outlier filter array
           outlier_fltr = repmat((std(vert_prop_tmp)*3+meds_curr),size(vert_prop,1),1);    %3 std away is too far
           %now filter out the outliers
           outlier_fltr = outlier_fltr<=vert_prop;
           for j = 1:size(outlier_fltr,2)
               distance(outlier_fltr(:,j)) = NaN;   %outliers set to NaN
           end
       end
       %clear
       vert_prop_tmp = [];outlier_fltr = [];
    end
    [y,x] = find(distance>thresh_now(i));         %get the location of non colocolizers
    [y_tmp,x] = find(isnan(distance));     %empty = no colo
    y = vertcat(y,y_tmp);                   %all together now.
    y = unique(y);                          %consolidate a little.
    distance(y,:) = [];                            %gone
    vertex(y,:) = [];                            %gone
    termi_vert(y,:) = [];                       %gone
    total_idx = vertcat(total_idx,y);           %add to the total index.
    %now store the data
    class(i).chan_idx = y;                %the index of removal for that channel
    class(i).number = size(vertex,1);     %number of occurances of this class in the data set.
    class(i).distance = distance;         %the colo distances
    class(i).ori_vert = vertex;             %the vertices of the colo occurances in the data set.
    class(i).termi_vert = termi_vert;     %the terminal vertices
    if mod
        ori_prop_tmp = vert_prop_ori;   %get a copy of ori properties
        vert_prop(y,:) = [];                        %gone
        class(i).termi_prop = vert_prop;       %the properties of the colocalized vertices
        ori_prop_tmp(y,:) = [];     %gone
        class(i).ori_prop = ori_prop_tmp;     %the properties of the ori channel
    end
end
clear distance vertex vert_prop i j termi_vert ori_prop_tmp

%clean up total index
total_idx = unique(total_idx);

%need to protect distances and vertices for change just in case the uber is
%called
distance = distances;
vertex = vertices;

%now generated the final all colo dataset
distance(total_idx,:) = [];        %gone
vertex(total_idx,:) = [];         %gone

%store the rest of the useful info.
class(1).channels = [ori chan];           %the channels included in this class.
class(1).names = punc_data(1).filenames(1,[ori chan]);    %the channel names.
class(1).threshold = thresh_now;        %the thresholds used.
class(1).total_idx = total_idx;         %the total index.
class(1).total_distances = distance;     %the distances of points that colo with all channels
class(1).total_vertices = vertex;       %the vertices that colo with all channels
class(1).total_number = size(vertex,1); %the number of vertices that colo with all channels
if mod
    ori_prop_tmp = vert_prop_ori;       %holder
    ori_prop_tmp(total_idx,:) = [];    %gone
    class(1).total_vert_prop = ori_prop_tmp;      %the properties for the ori channel
end
clear distance vertex ori_prop_tmp

%are you prepared for uber...are you?
if strcmp(thresh,'uber')
    %ok lets pull out the sliding threshold channel.
    s_thresh = punc_data(ori).distance(:,1,termi);
    %initialize and preallocate
    ytotal = [];
    %now loosely filter the slideing threshold for far out data
    [yfar,x] = find(s_thresh>(median(s_thresh(~isnan(s_thresh)))+std(s_thresh(~isnan(s_thresh)))*2));
    [ynan,x] = find(isnan(s_thresh));
    %now give s_thresh a little wiggle room
    %s_thresh = s_thresh+repmat(std(s_thresh(~isnan(s_thresh))),size(s_thresh,1),1);     %give it 1 STD wiggle room
    %get the termini location of the base vector
    base_termi_vert = punc_data(ori).termi(:,:,termi);
    %create the modification index of the sliding index(base vector)
    if mod
        %pull some needed data
        vert_prop_termi = punc_data(ori).termi_prop(:,:,termi);
        %figure out the modifier
        %get the medians for all props first
        [y,x] = find(isnan(vert_prop_termi));   %remove not a number first
        vert_prop_tmp = vert_prop_termi;       %temp the variable to be worked on
        vert_prop_tmp(y,:) = [];     %gone
        meds_termi = median(vert_prop_tmp);    %median
        %generate ori modification index
        termi_mod_idx = mean(vert_prop_termi./repmat(meds_termi,size(vert_prop_termi,1),1),2);
        %filter termi for outliers
        if mod_fltr
            %create the outlier filter array
            outlier_fltr = repmat((std(vert_prop_tmp)*3+meds_termi),size(vert_prop_termi,1),1);    %3 std away is too far
            %now filter out the outliers
            outlier_fltr = outlier_fltr<=vert_prop_termi;
            for i = 1:size(outlier_fltr,2)
                termi_mod_idx(outlier_fltr(:,i)) = NaN;   %outliers set to NaN
            end
        end
        %now using the ori and termi mod indexs to create the final mod
        mod_idx = mean([termi_mod_idx ori_mod_idx],2);
        %modifty the threshold based on the punctas at then ori and termini
        %of the base vector
        s_thresh = s_thresh.*mod_idx;
        %clear
        vert_prop_tmp = [];outlier_fltr = [];
    end
    %now step through the channels
    for j = 1:size(chan,2)
        if chan(j)~=termi && chan(j)~=ori       %no ori or termi in this comparision
            distance = distances(:,j);  %pull out the relavent distances
            termi_vert = punc_data(ori).termi(:,:,chan(j));     %the terminal vertices
            %modify the distance based on the puncta parameters
            if mod
                %pull some needed data
                vert_prop = punc_data(ori).termi_prop(:,:,chan(j));
                %figure out the modifier
                %get the medians for all props first
                [y,x] = find(isnan(vert_prop));   %remove not a number first
                vert_prop_tmp = vert_prop;       %temp the variable to be worked on
                vert_prop_tmp(y,:) = [];     %gone
                meds_curr = median(vert_prop_tmp);    %median
                %modify the distances
                distance = (distance.*ori_mod_idx)./mean(vert_prop./repmat(meds_curr,size(vert_prop,1),1),2);
                %filter vertices for outliers
                if mod_fltr
                    %create the outlier filter array
                    outlier_fltr = repmat((std(vert_prop_tmp)*3+meds_curr),size(vert_prop,1),1);    %3 std away is too far
                    %now filter out the outliers
                    outlier_fltr = outlier_fltr<=vert_prop;
                    for k = 1:size(outlier_fltr,2)
                        distance(outlier_fltr(:,k)) = NaN;   %outliers set to NaN
                    end
                end
                %clear
                vert_prop_tmp = [];outlier_fltr = [];
            end
            vertex = vertices;          %new variable so we do not destroy vertices.
            [ytmp,x] = find(isnan(distance));       %remove the nan in this data set as well
            [y,x] = find(distance>s_thresh);         %get the location of non colocolizers
            y = unique(vertcat(y,ytmp,yfar,ynan));        %remove all unmatch or unqualified data points
            distance(y,:) = [];         %gone
            vertex(y,:) = [];                            %gone
            termi_vert(y,:) = [];       %gone
            ytotal = vertcat(ytotal,y);           %add to the total index.
            %now store the data
            class(j).s_chan_idx = y;                %the index of removal for that channel
            class(j).s_number = size(vertex,1);     %number of occurances of this class in the data set.
            class(j).s_distance = distance;         %the colo distances
            class(j).s_ori_vert = vertex;           %the vertices of the colo occurances in the data set.
            class(j).s_termi_vert = termi_vert;     %the termi vertices
            if mod
                ori_prop_tmp = vert_prop_ori;   %get a copy of ori properties
                vert_prop(y,:) = [];    %gone
                class(j).s_termi_prop = vert_prop;       %the properties of the colocalized vertices
                ori_prop_tmp(y,:) = [];     %gone
                class(j).s_ori_prop = ori_prop_tmp;     %the properties of the ori channel
            end
        end
    end
    %clean up total index
    ytotal = unique(ytotal);
    %now generated the final all colo dataset
    distances(ytotal,:) = [];        %gone
    vertices(ytotal,:) = [];         %gone
    base_termi_vert(ytotal,:) = [];  %gone
    %store uber data
    class(1).s_total_idx = ytotal;         %the total index.
    class(1).s_total_distances = distances;     %the distances of points that colo with all channels
    class(1).s_total_ori_vert = vertices;       %the vertices that colo with all channels
    class(1).s_total_number = size(vertices,1); %the number of vertices that colo with all channels
    class(1).s_total_termi_vert = base_termi_vert;  %the vertices of the terminal channel
    if mod
        vert_prop_ori(ytotal,:) = [];    %gone
        class(1).s_total_ori_prop = vert_prop_ori;      %the properties for the ori channel
        vert_prop_termi(ytotal,:) = [];  %gone
        class(1).s_total_termi_prop = vert_prop_termi;      %the properties for the ori channel
    end
end

%--------------------------------------------------------------------------
%subfunction to parse the inputs.
function [mod,mod_fltr,thresh,termi] = parse(input,chan)

mod = 0;  %Default Initialized.
mod_fltr = 0;
thresh = 'median1';  %Center is off at default
termi = chan(1,1);    %base scale of a unit in the x axis

%Parse the input
if ~isempty(input)
    for i = 1:2:size(input,2)
        if ischar(input{1,i});
            switch input{1,i}
                case 'mod'
                    mod = input{1,i+1};
                case 'mod_fltr'
                    mod_fltr = input{1,i+1};
                case 'thresh'
                    thresh = input{1,i+1};
                case 'termi'
                    termi = input{1,i+1};
                otherwise
                    warning(['Your input ',input{1,i},' is not recognized.']);
            end
        end
    end
end
if isnumeric(thresh)        %user defined thresh
    if size(chan)~=size(thresh)
        error(['The number of threshold entered must be equal to the number of channels entered'])
    end
end